/**
 * 
 */
package com.ejie.ab18a.control.mantenimiento;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejie.ab18a.model.Ab18aEstadoPeticion;
import com.ejie.ab18a.service.Ab18aEstadoPeticionService;
import com.ejie.ab18a.utils.Constantes;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;

/**
 * @author XXXX
 * 
 */
@Controller
@RequestMapping(value = "/estadoPeticion")
public class Ab18aEstadoPeticionMtoController {

	/** The Constant logger. */
	private static final Logger logger = LoggerFactory.getLogger(Ab18aEstadoPeticionMtoController.class);

	@Autowired
	private Ab18aEstadoPeticionService ab18aEstadoPeticionService;

	@Autowired
	private ReloadableResourceBundleMessageSource messageSource;

	@RequestMapping(value = "mantenimiento", method = RequestMethod.GET)
	public String viewMantenimiento() {
		logger.info("mantenimiento de los Estados de la peticion");
		return "ab18aEstadoPeticionMantenimiento";
	}

	/**
	 * Buscamos los boletines correspondientes a los valores del filtro
	 **/
	@RequestMapping(value = "mantenimiento/tabla", method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridResponseDto<Ab18aEstadoPeticion> buscarEstadosPeticion(@ModelAttribute() Ab18aEstadoPeticion estadoFiltro,
			@ModelAttribute() JQGridRequestDto request) {

		List<Ab18aEstadoPeticion> listaEstado = new ArrayList<Ab18aEstadoPeticion>();
		Long recordNum = Long.valueOf("12125");
		try {
			listaEstado = this.ab18aEstadoPeticionService.findAllLike(estadoFiltro, request, false);
			recordNum = this.ab18aEstadoPeticionService.findAllLikeCount(estadoFiltro, false);
		} catch (Exception e) {
			Ab18aEstadoPeticionMtoController.logger
					.error("Ab18aEstadoPeticionMtoController - buscarEstadosPeticion() - Error al obtener la lista de los estados de las peticiones - "
							+ e);
		}

		JQGridResponseDto<Ab18aEstadoPeticion> response = new JQGridResponseDto<Ab18aEstadoPeticion>(request, recordNum, listaEstado);
		return response;
	}

	/**
	 * Method 'guardarMantenimiento'.
	 * 
	 * @param mantenimiento
	 *            Y96bMantenimiento
	 * @return Y96bMantenimiento
	 * @throws Exception
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Ab18aEstadoPeticion guardarMantenimiento(@RequestBody Ab18aEstadoPeticion mantenimiento, HttpServletResponse response) throws Exception {
		Ab18aEstadoPeticion mantenimientoAux = null;

		if (mantenimiento.getT11IdEstado() != null && mantenimiento.getT11IdEstado() > 0) {
			/**
			 * idRegistro > 0 implica que es una modificación.
			 */
			mantenimientoAux = this.ab18aEstadoPeticionService.update(mantenimiento);
			Ab18aEstadoPeticionMtoController.logger.info("[POST] : Ab18aEstadoPeticion mantenimiento actualizado correctamente");
		} else {
			if (this.ab18aEstadoPeticionService.findEstadoByCod(mantenimiento.getT11CodEstado()) <= 0) {
				try {
					mantenimientoAux = this.ab18aEstadoPeticionService.add(mantenimiento);
					Ab18aEstadoPeticionMtoController.logger.info("[POST] : Ab18aEstadoPeticion mantenimiento insertado correctamente");
				} catch (Exception e) {
					Ab18aEstadoPeticionMtoController.logger.error("[POST] : Ab18aEstadoPeticion error al añadir un registro al mantenimiento: " + e);
					throw e;
				}
			} else {
				response.sendError(Constantes.HTTP_STATUS_EXPECTATION_FAILED,
						this.messageSource.getMessage("mantenimientos.validacion.codigoRepetido", null, LocaleContextHolder.getLocale()));
			}
		}

		return mantenimientoAux;
	}

	/**
	 * @param messageSource
	 *            ReloadableResourceBundleMessageSource-.
	 */
	public void setMessageSource(ReloadableResourceBundleMessageSource messageSource) {
		this.messageSource = messageSource;
	}
}
